/*
 * Decompiled with CFR 0.152.
 */
package net.pevori.queencats.entity.custom;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.pevori.queencats.gui.menu.HumanoidAnimalMenu;
import org.jetbrains.annotations.Nullable;

public class HumanoidAnimalEntity
extends TamableAnimal
implements ContainerListener,
HasCustomInventoryScreen,
MenuProvider {
    protected static final String INVENTORY_KEY = "Humanoid_Animal_Inventory";
    protected static final String ARMOR_KEY = "Humanoid_Animal_Armor_Item";
    protected static final String SLOT_KEY = "Humanoid_Animal_Inventory_Slot";
    protected SimpleContainer inventory = new SimpleContainer(19);

    protected HumanoidAnimalEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.updateInventory();
        this.registerDoorNavigation();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
    }

    private void registerDoorNavigation() {
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        ((GroundPathNavigation)this.m_21573_()).m_148214_(true);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!this.f_19853_.f_46443_ && this.m_21830_((LivingEntity)player) && !this.m_6162_() && this.hasArmorSlot() && this.isValidArmor(itemStack) && !this.hasArmorInSlot()) {
            this.equipArmor(player, itemStack);
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (!this.f_19853_.f_46443_ && this.m_21830_((LivingEntity)player) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (player.m_6144_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buf -> {
                    buf.writeInt(this.m_19879_());
                    buf.writeInt(this.m_19879_());
                });
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean hasArmorSlot() {
        return !this.m_6162_();
    }

    public boolean hasArmorInSlot() {
        return this.m_21033_(EquipmentSlot.CHEST);
    }

    public boolean isValidArmor(ItemStack itemStack) {
        ArmorItem item;
        Item item2 = itemStack.m_41720_();
        return item2 instanceof ArmorItem && (item = (ArmorItem)item2).m_40402_() == EquipmentSlot.CHEST;
    }

    public void equipArmor(Player player, ItemStack stack) {
        if (!this.m_9236_().m_5776_() && this.isValidArmor(stack)) {
            this.inventory.m_6836_(0, new ItemStack((ItemLike)stack.m_41720_()));
            this.m_5496_(stack.m_150920_(), 0.5f, 1.0f);
            this.equipArmor(stack);
            this.inventory.m_6596_();
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        }
    }

    public void equipArmor(ItemStack stack) {
        if (!this.m_9236_().m_5776_() && this.isValidArmor(stack)) {
            this.m_8061_(EquipmentSlot.CHEST, stack);
            this.m_21409_(EquipmentSlot.CHEST, 0.0f);
        }
    }

    public int getInventorySize() {
        return 19;
    }

    protected void updateInventory() {
        SimpleContainer previousInventory = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (previousInventory != null) {
            previousInventory.m_19181_((ContainerListener)this);
            int maxSize = Math.min(previousInventory.m_6643_(), this.inventory.m_6643_());
            for (int slot = 0; slot < maxSize; ++slot) {
                ItemStack stack = previousInventory.m_8020_(slot);
                if (stack.m_41619_()) continue;
                this.inventory.m_6836_(slot, stack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.syncInventoryToFlags();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemStack = this.inventory.m_8020_(i);
                if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack)) continue;
                this.m_19983_(itemStack);
            }
        }
    }

    public void syncInventoryToFlags() {
        if (!this.m_9236_().m_5776_()) {
            this.equipArmor(this.inventory.m_8020_(0));
        }
    }

    public void m_5757_(Container pContainer) {
        boolean previouslyEquipped = this.hasArmorInSlot();
        this.syncInventoryToFlags();
        if (this.f_146733_ > 20 && !previouslyEquipped && this.hasArmorInSlot()) {
            SoundEvent armorInSlotEquipSound = this.inventory.m_8020_(0).m_150920_();
            this.m_5496_(armorInSlotEquipSound, 0.5f, 1.0f);
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag listTag = new ListTag();
        if (!this.inventory.m_8020_(0).m_41619_()) {
            nbt.m_128365_(ARMOR_KEY, (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        for (int i = 1; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_(SLOT_KEY, (byte)i);
            itemStack.m_41739_(compoundtag);
            listTag.add((Object)compoundtag);
        }
        nbt.m_128365_(INVENTORY_KEY, (Tag)listTag);
    }

    public void m_7378_(CompoundTag nbt) {
        ItemStack itemStack;
        super.m_7378_(nbt);
        ListTag nbtList = nbt.m_128437_(INVENTORY_KEY, 10);
        if (nbt.m_128425_(ARMOR_KEY, 10) && !(itemStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_(ARMOR_KEY))).m_41619_() && this.isValidArmor(itemStack)) {
            this.inventory.m_6836_(0, itemStack);
            this.equipArmor(itemStack);
        }
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag compoundtag = nbtList.m_128728_(i);
            int j = compoundtag.m_128445_(SLOT_KEY) & 0xFF;
            if (j < 1 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
    }

    protected void setInventory(SimpleContainer inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            this.inventory.m_6836_(i, inventory.m_8020_(i));
            this.inventory.m_6596_();
        }
    }

    public SimpleContainer getInventory() {
        if (this.inventory == null) {
            return new SimpleContainer(this.getInventorySize());
        }
        return this.inventory;
    }

    public boolean m_7757_(LivingEntity entity, LivingEntity owner) {
        if (!(entity instanceof Creeper) && !(entity instanceof Ghast)) {
            if (entity instanceof HumanoidAnimalEntity) {
                HumanoidAnimalEntity humanoid = (HumanoidAnimalEntity)entity;
                return !humanoid.m_21824_() || humanoid.m_21826_() != owner;
            }
            if (entity instanceof Player && owner instanceof Player && !((Player)owner).m_7099_((Player)entity)) {
                return false;
            }
            if (entity instanceof AbstractHorse && ((AbstractHorse)entity).m_30614_()) {
                return false;
            }
            return !(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_();
        }
        return false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new HumanoidAnimalMenu(syncId, playerInventory, this);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public void m_213583_(Player pPlayer) {
    }
}

